/*
 * $Id: rrdfile.h,v 1.2 2005/08/26 17:51:44 d1mag Exp $
 *
 * temploggerd -- graph/log utility written for OWFS
 * Written 2005 Christian Magnusson
 * email: mag@mag.cx
 * Released under the GPL
*/
#ifndef RRDFILE_H
#define RRDFILE_H

#include <globals.h>

struct rrd_ds {
  char name[FILENAME_LEN+1];
  int exists;
  struct rrd_ds *next;
};

struct rrd_file {
  char name[FILENAME_LEN+1];
  char tmpl_all[FILENAME_LEN+1];
  char tmpl_sensor[FILENAME_LEN+1];
  char description[FILENAME_LEN+1];
  int nr_sensors;
  struct rrd_ds *ds;
  struct rrd_file *next;
};

extern struct rrd_file *rrd_files;
//extern char rrdfile_default[FILENAME_LEN+1];

enum rrdfile_state { OUTSIDE_LOOP, INSIDE_RRDFILE_LOOP, INSIDE_SENSOR_LOOP };
extern enum rrdfile_state rrdfile_output;

struct rrd_file *add_rrdfile(char *name, char *tmpl_all, char *tmpl_sensor, char *description);

struct rrd_ds *add_rrd_ds(struct rrd_file *r, char *name, int exists);
struct rrd_ds *find_rrd_ds(struct rrd_file *r, char *name);

void cleanup_rrd_ds(struct rrd_file *r);
void free_rrd_ds(struct rrd_file *r, char *name);

int read_rrd_file(struct rrd_file *r);

#endif
