/*
 * $Id: scan_bus.c,v 1.5 2006/09/17 19:05:27 d1mag Exp $
 *
 * temploggerd -- graph/log utility written for OWFS
 * Written 2005 Christian Magnusson
 * email: mag@mag.cx
 * Released under the GPL
*/
#include <features.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <dirent.h>
#include <errno.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <ctype.h>
#include <stdarg.h>

#include <globals.h>
#include <sensor.h>
#include <util.h>
#include <scan_bus.h>

unsigned char new_device_found = 0;

int find_fusedev(char *mount_dir, char *path, char *upath)
{
  char tmp[128];
  char *p = NULL, *p2;
  FILE *fp;
  int found = 0;
  struct stat st;
  if(path) *path = '\0';
  if(upath) *upath = '\0';

  if(mount_dir && mount_dir[0]) {
    if(stat(mount_dir, &st) < 0) {
      printf("%s doesn't exist\n", mount_dir);
      return 0;
    }
    if(!S_ISDIR(st.st_mode)) {
      printf("%s is not a directory\n", mount_dir);
      return 0;
    }
    if(path) strcpy(path, mount_dir);
    if(upath) strcpy(upath, mount_dir);
    //printf("Force reading sensors from [%s]\n", mount_dir);
    return 1;
  }

  fp = fopen("/proc/mounts", "r");
  if(!fp) {
    return found;
  }
  while(!feof(fp)) {
    if(!(p = fgets(tmp, 80, fp))) {
      break;
    }
    p2 = strtok(p, " ");
    if(p2) p2 = strtok(NULL, " ");
    if(p2) {
      if(path) strcpy(path, p2);
      p2 = strtok(NULL, " ");
    }
    if(p2 && !strncmp(p2, "fuse", 4)) {
      found = 1;
      break;
    }
  }
  fclose(fp);

  if(found) {
    if(path && upath) {
      strcpy(upath, path);
      strcat(upath, "/uncached");
    }
  } else {
    if(path) *path = '\0';
  }
  return found;
}

int remove_uncached( char * path ) {
    char * p ;
    char * del ;
    char * rest = path ;
    while ( (p = strsep(&rest,"/")) ) {
        if (rest) rest[-1]='/' ; /* restore delimiter */
        if ( !strncasecmp( p, "uncached", 8 ) ) {
	  if((del = strchr(p, '/'))) {
	    memmove( p, del+1, strlen(del+1)+1 );
	  } else {
	    *p = '\000';
	  }
	  return 0 ;
        }
    }
    return 1 ; /* no bus found */
}

int scan_bus(char *path)
{
  struct dirent **namelist;
  int n, i;
  int nr_sensors;
  int device_id;
  char subdir[128];
  struct sensor *ss, *s, *s2;
  int added;
  char file[FILENAME_LEN+1];
  char cached_path[FILENAME_LEN+1];
  struct stat st;
  int rc;
  
  //printf("scan_bus [%s]\n", path);

  strncpy(cached_path, path, FILENAME_LEN);
  remove_uncached(cached_path);

  nr_sensors = 0;
  if((n = scandir(path, &namelist, 0, alphasort)) < 0) {
    printf("scan_bus scandir: [%s] %s\n", path, strerror(errno));
    return 0;
  }
  while(n--) {
    //printf("scan_bus found: [%s]\n", namelist[n]->d_name);
    if(!strcmp(namelist[n]->d_name, ".") ||
       !strcmp(namelist[n]->d_name, "..") ||
       (strlen(namelist[n]->d_name)!=15)
       ) {
      free(namelist[n]);
      namelist[n] = NULL;
      continue;
    }
    for(i=0; i<15; i++) {
      if(i==2) {
	if(namelist[n]->d_name[i]!='.') break;
      } else {
	if(!isxdigit(namelist[n]->d_name[i])) break;
      }
    }
    if(i<15) {
      free(namelist[n]);
      namelist[n] = NULL;
      continue;
    }

    device_id = char2hex(namelist[n]->d_name[0])*16+char2hex(namelist[n]->d_name[1]);
    switch(device_id) {
    case 0x1F:
      sprintf(subdir, "%s/%s/main", path, namelist[n]->d_name);
      //printf("search subdir [%s]\n", subdir);
      nr_sensors += scan_bus(subdir);
      sprintf(subdir, "%s/%s/aux", path, namelist[n]->d_name);
      //printf("search subdir [%s]\n", subdir);
      nr_sensors += scan_bus(subdir);
      break;
    default:
      s = sensors;
      nr_sensors++;
      added = 0;
      while((ss = find_sensor_from(s, namelist[n]->d_name))) {
	sprintf(file, "%s/%s/%s", path, ss->id, ss->datafile);
	if(((rc = stat(file, &st)) == 0)
	   /* && (S_ISREG(st.st_mode)) */
	   ) {
	  // file exists in both config-file and on bus... add it
	  //if(rc==0) printf("file exist [%s]\n", file);
	  if(!(s2=add_sensor(cached_path, namelist[n]->d_name, NULL, nr_sensors, 1, NULL, ss->datafile))) {
	    printf("scan_bus: Error adding (from config) [%s]\n", namelist[n]->d_name);
	    exit(0);
	  }
	  if(!s2->file_found_on_bus) new_device_found = 1;
	  s2->device_found_on_bus = 1;
	  s2->file_found_on_bus = 1;
	  added = 1;
	} else {
	  /* should perhaps add it anyway !! */
	  printf("Warning: [%s] doesn't exist (defined in config-file)\n", file);
	  if(!(s2=add_sensor(cached_path, namelist[n]->d_name, NULL, nr_sensors, 0, NULL, ss->datafile))) {
	    printf("scan_bus: Error adding (from config) [%s]\n", namelist[n]->d_name);
	    exit(0);
	  }
	  s2->device_found_on_bus = 1;
	  s2->file_found_on_bus = 0;
	  added = 1;
	}
	s = ss->next;
      }
      if(!added) {
	if(is_tempsensor(device_id)) {
	  int file_exists = 0;
	  //printf("is tempsensor [%s]\n", namelist[n]->d_name);
	  sprintf(file, "%s/%s/%s", path, namelist[n]->d_name, "temperature");
	  if((rc = stat(file, &st)) == 0) {
	    file_exists = 1;
	  } 
	  if(!(s = add_sensor(cached_path, namelist[n]->d_name, NULL, nr_sensors, file_exists, NULL, "temperature"))) {
	    printf("scan_bus: Error adding [%s]\n", namelist[n]->d_name);
	    exit(0);
	  }
	  if(!s->file_found_on_bus && file_exists) new_device_found = 1;
	  s->device_found_on_bus = 1;
	  s->file_found_on_bus = file_exists;
	} else {
	  //printf("add unknown sensor [%s]\n", namelist[n]->d_name);
	  if(!(s=add_sensor(cached_path, namelist[n]->d_name, NULL, nr_sensors, 0, NULL, NULL))) {
	    printf("scan_bus: Error adding [%s]\n", namelist[n]->d_name);
	    exit(0);
	  }
	  if(!s->file_found_on_bus) new_device_found = 1;
	  s->device_found_on_bus = 1;
	}
      }
      break;
    }
    free(namelist[n]);
    namelist[n] = NULL;
  }
  free(namelist);
  namelist = NULL;
  return nr_sensors;
}
