/*
 * $Id: sensor.h,v 1.6 2008/01/04 16:07:48 d1mag Exp $
 *
 * temploggerd -- graph/log utility written for OWFS
 * Written 2005 Christian Magnusson
 * email: mag@mag.cx
 * Released under the GPL
*/
#ifndef SENSOR_H
#define SENSOR_H

#include <globals.h>
#include <rrdfile.h>

struct sensor {
  char full_path[FILENAME_LEN+1]; // Full path to device
  char uncached_path[FILENAME_LEN+1]; // Full uncached path to device
  char id[DEVICE_ID_LEN+1];       // Debice ID
  char location[LOCATION_LEN+1];  // Text description, if available
  char datafile[FILENAME_LEN+1];  // typically temperature or volt.A
  char color[COLOR_LEN+1];        // user-defined color
  struct rrd_file *rrdfile;       // file.rrd to save values in.
  int rrdtype;                    // 0=GAUGE 1=COUNTER 2=DERIVE
  int minval;                     // default: -40
  int maxval;                     // default: 256
  int column;                     // used for color perhaps...?
  int avail;                      // last value was ok...
  int ignored;                    // sensor is ignored by config-file
  int config_sensor;              // defined in config-file
  int device_found_on_bus;        // device was found on 1-wire bus
  int file_found_on_bus;          // device was found on 1-wire bus
  float last_value;
  struct sensor *next;
};

extern struct sensor *sensors;

struct sensor *add_sensor(char *path, char *id, char *location, int column, int found_on_bus, char *rrdfile, char *datafile);
int change_sensor(char *id, char *datafile, char *location);
int free_sensor(struct sensor *s);
int free_sensors(void);
int delete_sensor_by_name(char *id);
int ignore_sensor(char *id);
int rrd_sensid(struct sensor *s, char *rrdid);
struct sensor *find_sensor_from(struct sensor *s, char *id);
struct sensor *find_sensor(char *id);
struct sensor *find_sensor_and_datafile(char *id, char *datafile);
int is_tempsensor(unsigned char device_id);
unsigned char sensor_id(struct sensor *s);
void update_sensors(char *path);
int nr_avail_sensors(void);
int print_sensor(struct sensor *s);
int owwire_write(char *path, char *file, char *value, int len);
int owwire_read(char *path, char *file, char *buf, int len);
int owwire_present(char *path);

#endif
