/*
 * $Id: config_var.c,v 1.8 2007/12/29 08:21:21 d1mag Exp $
 *
 * temploggerd -- graph/log utility written for OWFS
 * Written 2005 Christian Magnusson
 * email: mag@mag.cx
 * Released under the GPL
*/

#include <features.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <globals.h>
#include <config_vars.h>
#include <rrdfile.h>
#include <sensor.h>
#include <simultaneous.h>

/* All config variables are defined as global variables...
 * Not very nice, but change it later.
 */

char owfs_dir[FILENAME_LEN+1];
char owshell_path[FILENAME_LEN+1];
char owshell_params[FILENAME_LEN+1];
char www_dir[FILENAME_LEN+1];
char base_dir[FILENAME_LEN+1];
char rrdfile_path[FILENAME_LEN+1];
char rrdfile_default[FILENAME_LEN+1];
char rrdfile_description_default[FILENAME_LEN+1];
char rrdcgi_file[FILENAME_LEN+1];
char rrdtool[FILENAME_LEN+1];
char rrdimg_path[FILENAME_LEN+1];
char images_path[FILENAME_LEN+1];
char cgi_dir[FILENAME_LEN+1];
char cgi_path[FILENAME_LEN+1];
char tmp_file[FILENAME_LEN+1];
char backup_dir[FILENAME_LEN+1];
char backup_freq[FILENAME_LEN+1];
int _backup_freq = 0;
char images_dir[FILENAME_LEN+1];
char tmpl_dir[FILENAME_LEN+1];
char config_file[FILENAME_LEN+1];
char tmpl_all_cgi[FILENAME_LEN+1];
char tmpl_all_default[FILENAME_LEN+1];
char tmpl_sensor_default[FILENAME_LEN+1];
char add_new_sensor_script[FILENAME_LEN+1];
char **tmpl_files = NULL;

struct config_vars conf[] = {
  {"config_file", config_file},
  {"owfs_dir", owfs_dir},
  {"owshell_path", owshell_path},
  {"owshell_params", owshell_params},
  {"rrdfile_path", rrdfile_path},
  {"rrdfile_default", rrdfile_default},
  {"rrdfile_description_default", rrdfile_description_default},
  {"rrdcgi_file", rrdcgi_file},
  {"rrdtool", rrdtool},
  {"www_dir", www_dir},
  {"base_dir", base_dir},
  {"rrdimg_path", rrdimg_path},
  {"images_path", images_path},
  {"cgi_dir", cgi_dir},
  {"cgi_path", cgi_path},
  {"tmp_file", tmp_file},
  {"backup_dir", backup_dir},
  {"backup_freq", backup_freq},
  {"images_dir", images_dir},
  {"tmpl_dir", tmpl_dir},
  {"tmpl_all_cgi", tmpl_all_cgi},
  {"tmpl_all_default", tmpl_all_default},
  {"tmpl_sensor_default", tmpl_sensor_default},
  {"add_new_sensor_script", add_new_sensor_script},
};



void set_defaults(void)
{
  char install_dir[FILENAME_LEN+1];
  backup_dir[0] = '\000';
  backup_freq[0] = '\000';
  _backup_freq = 0;
  owfs_dir[0] = '\000';
  owshell_path[0] = '\000';
  owshell_params[0] = '\000';
  strcpy(tmp_file, "/tmp/temploggerd.tmp");
  strcpy(rrdtool, "rrdtool");
  add_new_sensor_script[0] = '\000';

  strcpy(tmpl_all_cgi, "all.cgi.templ");
  strcpy(tmpl_all_default, "all_temperature.cgi.templ");
  strcpy(tmpl_sensor_default, "sensor_temperature.cgi.templ");

  strcpy(rrdimg_path, "rrd/");
  strcpy(images_path, "images/");

#ifdef __UCLIBC__
 #ifdef CONFIG_COLDFIRE
  strcpy(rrdfile_path, "/var/httpd/temploggerd/rrd/");
  strcpy(rrdfile_default, "temperature.rrd");
  strcpy(rrdcgi_file, "/usr/bin/rrdcgi");
  strcpy(www_dir, "/var/httpd/");
  strcpy(base_dir, "/temploggerd/");
  strcpy(cgi_dir, "/var/httpd/cgi-bin/");
  strcpy(cgi_path, "/cgi-bin/");
  strcpy(config_file, "/etc/config/temploggerd.conf");
 #else /* CONFIG_COLDFIRE */
  strcpy(rrdfile_path, "/var/www/temploggerd/rrd/");
  strcpy(rrdfile_default, "temperature.rrd");
  strcpy(rrdcgi_file, "/var/bin/rrdcgi");
  strcpy(www_dir, "/var/www/");
  strcpy(base_dir, "/temploggerd/");
  strcpy(cgi_dir, "/var/www/cgi-bin/");
  strcpy(cgi_path, "/cgi-bin/");
  // openwrt should be /etc
  //strcpy(config_file, "/etc/temploggerd.conf");
  strcpy(config_file, "/var/bin/temploggerd.conf");
 #endif /* CONFIG_COLDFIRE */
  strcpy(install_dir, "/usr/local/lib/temploggerd/");
  sprintf(images_dir, "%simages/", install_dir);
  sprintf(tmpl_dir, "%stemplates/", install_dir);
  sprintf(tmpl_dir, "%s%s", www_dir, base_dir);
#else /* __UCLIBC__ */
  strcpy(rrdfile_path, "/var/www/html/temploggerd/rrd/");
  strcpy(rrdfile_default, "temperature.rrd");
  strcpy(rrdcgi_file, "/usr/local/bin/rrdcgi");
  strcpy(www_dir, "/var/www/html/");
  strcpy(base_dir, "/temploggerd/");
  strcpy(cgi_dir, "/var/www/cgi-bin/");
  strcpy(cgi_path, "/cgi-bin/");
  strcpy(install_dir, "/usr/local/lib/temploggerd/");
  sprintf(images_dir, "%simages/", install_dir);
  sprintf(tmpl_dir, "%stemplates/", install_dir);
  sprintf(config_file, "%stemploggerd.conf", install_dir);
  strcpy(add_new_sensor_script, "add_new_sensor.sh");
#endif /* __UCLIBC__ */

  sprintf(rrdfile_description_default, "Temperatures");

}


void print_defaults(void)
{
  int i;
  int sz = sizeof(conf)/sizeof(struct config_vars);

  printf("Default values:\n");
  for(i=0; i<sz; i++) {
    printf("%-20s %s\n", conf[i].name, conf[i].value);
  }
  if(tmpl_files) {
    i = 0;
    while(tmpl_files[i]) {
      printf("template[%d]\t%s\n", i, tmpl_files[i]);
      i++;
    }
  }
  exit(0);
}


int read_config_file(int modify_sensors)
{
  FILE *fp;
  char tmp[ROW_LEN+1];
  char *t;
  int rc, i, ignored;
  char sens_id[ROW_LEN+1], sens_name[ROW_LEN+1];
  struct sensor *s;

  /* Remove existing template files. They will be re-read from config-file */
  if(tmpl_files) {
    i = 0;
    while(tmpl_files[i]) {
      free(tmpl_files[i]);
      tmpl_files[i] = NULL;
      i++;
    }
    free(tmpl_files);
    tmpl_files = NULL;
  }

  //printf("read_config_file: [%s]\n", config_file);
  fp = fopen(config_file, "r");
  if(!fp) {
    printf("Error: Can't open config-file [%s]\n", config_file);
    return -1;
  }
  while(!feof(fp)) {
    if(!(t = fgets(tmp, ROW_LEN, fp))) break;
    //printf("read: [%s]\n", tmp);
    while(*t && ((*t=='\t') || (*t==' ') || (*t=='\n') || (*t=='\r'))) t++;
    if(!*t || (*t == '#')) continue;
    //printf("read: t=[%s]\n", t);
#ifndef IGNORE_SIMULTANEOUS
    if(!strncasecmp(t, "simultaneous", 12)) {
      char simulfile[FILENAME_LEN+1];
      struct simultaneous *sim ;
      char *e;
      t += 12;
      while(*t && ((*t=='\t') || (*t==' '))) t++;

      if(*t == '"') {
	e = t+1;
	while(*e && (*e!='"')) e++;
	if(*e == '"') {
	  int len = (unsigned long)e-(unsigned long)t-1;
	  strncpy(simulfile, t+1, len);
	  simulfile[len] = '\000';
	} else {
	  printf("can't find ending \"\n");
	  goto error_parsing;
	}
	t = e+1;
      } else {
	rc = sscanf(t, "%s", simulfile);
	if(rc != 1) {
	  printf("can't find any simultaneous filename [%s]\n", t);
	  goto error_parsing;
	}
	t += strlen(simulfile);
      }
      if(!(sim=add_simultaneous(simulfile))) {
	printf("Error adding simultaneous file\n");
	exit(0);
      }
    } else
#endif
    if(!strncasecmp(t, "sensor_type", 11)) {
      char rrdtype[FILENAME_LEN+1];
      char datafile[FILENAME_LEN+1];
      int minval = -40;
      int maxval = 256;
      int rrdtype_nr = 0;
      t += 11;
      while(*t && ((*t=='\t') || (*t==' '))) t++;
      rc = sscanf(t, "%s", sens_id);
      if(rc != 1) {
	printf("can't find any sensor name [%s]\n", t);
	goto error_parsing;
      }
      t += strlen(sens_id);
      while(*t && ((*t=='\t') || (*t==' '))) t++;

      rc = sscanf(t, "%s", datafile);
      if(rc != 1) {
	printf("can't find datafile argument\n");
	goto error_parsing;
      }

      if(!(s=find_sensor_and_datafile(sens_id, datafile))) {
	printf("can't find sensor [%s] [%s]\n", sens_id, datafile);
	printf("create sensor before setting sensor_type\n");
	goto error_parsing;
      }

      t += strlen(datafile);
      while(*t && ((*t=='\t') || (*t==' '))) t++;

      rc = sscanf(t, "%s", rrdtype);
      if(rc != 1) {
	printf("can't find any sensor rrdtype [%s]\n", t);
	goto error_parsing;
      }
      if(!strcasecmp(rrdtype, "GAUGE"))
	rrdtype_nr = 0;
      else if(!strcasecmp(rrdtype, "COUNTER"))
	rrdtype_nr = 1;
      else if(!strcasecmp(rrdtype, "DERIVE"))
	rrdtype_nr = 2;
      else {
	printf("Valid rrdtypes are GAUGE, COUNTER and DERIVE [%s]\n", t);
	goto error_parsing;
      }
      t += strlen(rrdtype);
      while(*t && ((*t=='\t') || (*t==' '))) t++;

      if(*t) {
	//printf("t=[%s]\n", t);
	rc = sscanf(t, "min %d", &minval);
	if(rc == 1) {
	  t += 3;
	  //printf("set minval = %d\n", minval);
	  while(*t && ((*t=='\t') || (*t==' '))) t++;
	  while(*t && ((*t!='\t') && (*t!=' '))) t++;
	  while(*t && ((*t=='\t') || (*t==' '))) t++;
	}
      }
      if(*t) {
	//printf("t2=[%s]\n", t);
	rc = sscanf(t, "max %d", &maxval);
	if(rc == 1) {
	  t += 3;
	  //printf("set maxval = %d\n", maxval);
	  while(*t && ((*t=='\t') || (*t==' '))) t++;
	  while(*t && ((*t!='\t') && (*t!=' '))) t++;
	  while(*t && ((*t=='\t') || (*t==' '))) t++;
	}
      }

      s->rrdtype = rrdtype_nr;
      s->minval = minval;
      s->maxval = maxval;
    } else
    if(!strncasecmp(t, "sensor", 6)) {
      char datafile[FILENAME_LEN+1];
      char rrdfile1[FILENAME_LEN+1];
      char sens_color[FILENAME_LEN+1];
      int set_color = 0;
      char *e;
      t += 6;
      while(*t && ((*t=='\t') || (*t==' '))) t++;
      rc = sscanf(t, "%s", sens_id);
      if(rc != 1) {
	printf("can't find any sensor name [%s]\n", t);
	goto error_parsing;
      }
      t += strlen(sens_id);
      while(*t && ((*t=='\t') || (*t==' '))) t++;

      if(*t == '"') {
	e = t+1;
	while(*e && (*e!='"')) e++;
	if(*e == '"') {
	  int len = (unsigned long)e-(unsigned long)t-1;
	  strncpy(sens_name, t+1, len);
	  sens_name[len] = '\000';
	  //printf("sens_name=[%s]\n", sens_name);
	} else {
	  printf("can't find ending \"\n");
	  goto error_parsing;
	}
	t = e+1;
      } else {
	rc = sscanf(t, "%s", sens_name);
	if(rc != 1) {
	  printf("can't find any sensor name [%s]\n", t);
	  goto error_parsing;
	}
	t += strlen(sens_name);
      }

      set_color = 0;
      sens_color[0] = '\000';
      rc = sscanf(t, "%s", sens_color);
      if(rc==1 &&
	 strlen(sens_color)==7 &&
	 sens_color[0]=='#' &&
	 isxdigit(sens_color[1]) &&
	 isxdigit(sens_color[2]) &&
	 isxdigit(sens_color[3]) &&
	 isxdigit(sens_color[4]) &&
	 isxdigit(sens_color[5]) &&
	 isxdigit(sens_color[6])) {
	set_color = 1;
	//printf("Set color=1 [%s] [%s]\n", sens_id, sens_color);
	t += 7;
	while(*t && ((*t!='\t') && (*t!=' '))) t++;
      } else {
	//printf("Set color=0 [%s] [%s]\n", sens_id, sens_color);
      }

      rc = sscanf(t, "%s %s", datafile, rrdfile1);
      //if(rc == 2) printf("Set1 [%s] [%s]\n", datafile, rrdfile1);
      if(rc != 2) {
	strcpy(rrdfile1, rrdfile_default);
	rc = sscanf(t, "%s", datafile);
	//if(rc == 1) printf("Set2 [%s]\n", datafile);
	if(rc != 1) {
	  strcpy(datafile, "temperature");
	  //goto error_parsing;
	}
      }
      if(datafile[0] == '/') {
	printf("datafile can't start with / for sensors\n");
	goto error_parsing;
      }
      ignored = 0;
      if((s=find_sensor(sens_id))) {
	if(s->ignored) {
	  ignored = 1;
	}
      }
      if(!(s=add_sensor(NULL, sens_id, sens_name, 0, 0, rrdfile1, datafile))) {
	printf("Error adding sensor\n");
	exit(0);
      }
      s->config_sensor = 1;
      if(ignored) {
	s->ignored = 1;
      }
      //printf("Vars [%s] [%s] [%s] [%s]\n", sens_id, sens_name, datafile, rrdfile1);
      if(modify_sensors) {
	change_sensor(sens_id, datafile, sens_name);
	if(set_color) {
	  strncpy(s->color, sens_color, COLOR_LEN);
	  s->color[COLOR_LEN] = '\000';
	} else {
	  s->color[0] = '\000';
	}
      }
    } else if(!strncasecmp(t, "file", 4)) {
      char datafile[FILENAME_LEN+1];
      char rrdfile1[FILENAME_LEN+1];
      char sens_color[FILENAME_LEN+1];
      int set_color = 0;
      char *e;
      t += 4;
      while(*t && ((*t=='\t') || (*t==' '))) t++;
      rc = sscanf(t, "%s", sens_id);
      if(rc != 1) {
	printf("can't find any sensor name [%s]\n", t);
	goto error_parsing;
      }
      t += strlen(sens_id);
      while(*t && ((*t=='\t') || (*t==' '))) t++;

      if(*t == '"') {
	e = t+1;
	while(*e && (*e!='"')) e++;
	if(*e == '"') {
	  int len = (unsigned long)e-(unsigned long)t-1;
	  strncpy(sens_name, t+1, len);
	  sens_name[len] = '\000';
	  //printf("sens_name=[%s]\n", sens_name);
	} else {
	  printf("can't find ending \"\n");
	  goto error_parsing;
	}
	t = e+1;
      } else {
	rc = sscanf(t, "%s", sens_name);
	if(rc != 1) {
	  printf("can't find any sensor name [%s]\n", t);
	  goto error_parsing;
	}
	t += strlen(sens_name);
      }
      //printf("sens_name = [%s]\n", sens_name);
      set_color = 0;
      sens_color[0] = '\000';
      rc = sscanf(t, "%s", sens_color);
      if(rc==1 &&
	 strlen(sens_color)==7 &&
	 sens_color[0]=='#' &&
	 isxdigit(sens_color[1]) &&
	 isxdigit(sens_color[2]) &&
	 isxdigit(sens_color[3]) &&
	 isxdigit(sens_color[4]) &&
	 isxdigit(sens_color[5]) &&
	 isxdigit(sens_color[6])) {
	set_color = 1;
	//printf("Set color=1 [%s] [%s]\n", sens_id, sens_color);
	t += 7;
	while(*t && ((*t!='\t') && (*t!=' '))) t++;
      } else {
	//printf("Set color=0 [%s] [%s]\n", sens_id, sens_color);
      }

      rc = sscanf(t, "%s %s", datafile, rrdfile1);
      //if(rc == 2) printf("Set1 [%s] [%s]\n", datafile, rrdfile1);
      if(rc != 2) {
	strcpy(rrdfile1, rrdfile_default);
	rc = sscanf(t, "%s", datafile);
	//if(rc == 1) printf("Set2 [%s]\n", datafile);
	if(rc != 1) {
	  strcpy(datafile, "temperature");
	  //goto error_parsing;
	}
      }
      if(datafile[0] != '/') {
	printf("datafile should start with / on files\n");
	goto error_parsing;
      }
      ignored = 0;
      if((s=find_sensor(sens_id))) {
	if(s->ignored) {
	  ignored = 1;
	}
      }
      if(!(s=add_sensor(NULL, sens_id, sens_name, 0, 0, rrdfile1, datafile))) {
	printf("Error adding sensor\n");
	exit(0);
      }
      s->config_sensor = 1;
      if(ignored) {
	s->ignored = 1;
      }
      //printf("Vars [%s] [%s] [%s] [%s]\n", sens_id, sens_name, datafile, rrdfile1);
      if(modify_sensors) {
	change_sensor(sens_id, datafile, sens_name);
	if(set_color) {
	  strncpy(s->color, sens_color, COLOR_LEN);
	  s->color[COLOR_LEN] = '\000';
	} else {
	  s->color[0] = '\000';
	}
      }
    } else if(!strncasecmp(t, "rrdfile_description", strlen("rrdfile_description"))) {
      char rrdfile[FILENAME_LEN+1];
      char value[FILENAME_LEN+1];
      char *e;
      t += strlen("rrdfile_description");
      while(*t && ((*t=='\t') || (*t==' '))) t++;
      if(*t == '"') {
	e = t+1;
	while(*e && (*e!='"')) e++;
	if(*e == '"') {
	  int len = (unsigned long)e-(unsigned long)t-1;
	  strncpy(rrdfile, t+1, len);
	  rrdfile[len] = '\000';
	  //printf("rrdfile=[%s]\n", rrdfile);
	} else {
	  printf("can't find ending \"\n");
	  goto error_parsing;
	}
	t = e+1;
      } else {
	rc = sscanf(t, "%s", rrdfile);
	if(rc != 1) {
	  printf("can't find any rrd-file [%s]\n", t);
	  goto error_parsing;
	}
	t += strlen(rrdfile);
      }

      while(*t && ((*t=='\t') || (*t==' '))) t++;
      rc = 0;
      if(!strncmp(t, "\"\"", 2)) { value[0] = 0; rc = 1; }
      if(rc != 1)
	rc = sscanf(t, "\"%[^\"\n]\n", value);
      //if(rc == 1) printf("Set1 [%s] = [%s]\n", t, value);
      if(rc != 1) {
	rc = sscanf(t, "%s\n", value);
	//if(rc == 1) printf("Set2 [%s] = [%s]\n", t, value);
	if(rc != 1) {
	  goto error_parsing;
	}
      }
      if(!add_rrdfile(rrdfile, NULL, NULL, value)) {
	printf("Error setting description to [%s]\n", rrdfile);
	exit(0);
      }
    } else if(!strncasecmp(t, "rrdfile", 7) && (t[7] != '_')) {
      char rrdfile[FILENAME_LEN+1];
      char template1[FILENAME_LEN+1];
      char template2[FILENAME_LEN+1];
      char *e; 
      struct rrd_file *r;
      //printf("t[7]=%c\n", t[7]);
      //printf("t=[%s]\n", t);
      t += 7;
      while(*t && ((*t=='\t') || (*t==' '))) t++;
      if(*t == '"') {
	e = t+1;
	while(*e && (*e!='"')) e++;
	if(*e == '"') {
	  int len = (unsigned long)e-(unsigned long)t-1;
	  strncpy(rrdfile, t+1, len);
	  rrdfile[len] = '\000';
	  //printf("rrdfile=[%s]\n", rrdfile);
	} else {
	  printf("can't find ending \"\n");
	  goto error_parsing;
	}
	t = e+1;
      } else {
	rc = sscanf(t, "%s", rrdfile);
	if(rc != 1) {
	  printf("can't find any rrd-file [%s]\n", t);
	  goto error_parsing;
	}
	t += strlen(rrdfile);
      }
      rc = sscanf(t, "%s %s", template1, template2);
      if(rc != 2) {
	printf("Expecting two templates for rrd-file [%s]\n", rrdfile);
	goto error_parsing;
      }

      if(!(r = add_rrdfile(rrdfile, template1, template2, NULL))) {
	printf("Error setting template to [%s]\n", rrdfile);
	exit(0);
      }
    } else if(!strncasecmp(t, "tmpl_files", strlen("tmpl_files"))) {
      char tmpl_file[FILENAME_LEN+1];
      char *e;
      char **tf;
      t += strlen("tmpl_files");

      while(*t) {
	while(*t && ((*t=='\t') || (*t==' '))) t++;
	if(*t == '"') {
	  e = t+1;
	  while(*e && (*e!='"')) e++;
	  if(*e == '"') {
	    int len = (unsigned long)e-(unsigned long)t-1;
	    strncpy(tmpl_file, t+1, len);
	    tmpl_file[len] = '\000';
	    //printf("tmpl_file=[%s]\n", tmpl_file);
	  } else {
	    printf("can't find ending \"\n");
	    goto error_parsing;
	  }
	  t = e+1;
	  rc = 1;
	} else {
	  rc = sscanf(t, "%s", tmpl_file);
	  if(rc != 1) {
	    break;
	  }
	  t += strlen(tmpl_file);
	}
	i = 0;
	if(!(tf = tmpl_files)) {
	  //printf("add first template\n");
	  if(!(tf = (char **)malloc(2*sizeof(char **))) ||
	     !(tf[i] = (char *)malloc(FILENAME_LEN+1))) {
	    printf("Error allocating memory for templates\n");
	    exit(0);
	  }
	} else {
	  while(tf[i]) i++;  // count number of entries
	  //printf("add at position %d\n", i);
	  if(!(tf = (char **)realloc(tf, (i+2)*sizeof(char **))) ||
	     !(tf[i] = (char *)malloc(FILENAME_LEN+1))) {
	    printf("Error allocating memory for templates\n");
	    exit(0);
	  }
	}
	tmpl_files = tf;
	strcpy(tf[i], tmpl_file);
	tf[i+1] = NULL;
	
	while(*t && ((*t=='\t') || (*t==' '))) t++;
      }
    } else if(!strncasecmp(t, "ignore", 6)) {
      rc = sscanf(&t[6], "%s\n", sens_id);
      if(rc != 1) goto error_parsing;
      //printf("read_config_file: ignore [%s]\n", sens_id);

      if(!(s=add_sensor(NULL, sens_id, NULL, 0, 0, NULL, NULL))) {
	printf("Error adding sensor\n");
	exit(0);
      }
      s->config_sensor = 1;
      s->ignored = 1;
      //if(modify_sensors) ignore_sensor(sens_id);
    } else {
      int ok = 0;
      for(i=0; i<(int)(sizeof(conf)/sizeof(struct config_vars)); i++) {
	char *name = conf[i].name;
	char *value = conf[i].value;
	//printf("Compare [%s] == [%s]\n", t, name);

	if(!strncasecmp(t, name, strlen(name))) {
	  t += strlen(name);
	  while(*t && ((*t=='\t') || (*t==' '))) t++;
	  if(!strncmp(t, "\"\"", 2)) { value[0] = 0; ok = 1; break; }
	  //if(*t == '"') t++;
	  rc = sscanf(t, "\"%[^\"\n]\n", value);
	  //if(rc == 1) printf("Set1 [%s] = [%s]\n", t, value);
	  if(rc == 1) { ok = 1; break; }
	  rc = sscanf(t, "%s\n", value);
	  //if(rc == 1) printf("Set2 [%s] = [%s]\n", t, value);
	  if(rc == 1) { ok = 1; break; }
	  goto error_parsing;
	}
      }
      if(!ok) {
	printf("Unknown config variable [%s]\n", t);
      }
    }
    continue;
  error_parsing:
    printf("read_config_file: Problem parsing [%s]", t);
  }
  fclose(fp);

  if(backup_freq[0]) {
    _backup_freq = atoi(backup_freq);
  } else {
    _backup_freq = 0;
  }
  return 0;
}

