#!/bin/tcsh -f

source ~maison/sensors.env

setenv TMPFILE `mktemp /tmp/get_temp.XXXXXX`

foreach id (${SENSID})
lynx -source http://192.168.1.10/data/log/${id}.log > ${TMPFILE}
setenv ERROR `grep "404 " ${TMPFILE}`

if { test -z "${ERROR}" } then
    mv ${TMPFILE} ${id}.log
else
    rm -f ${id}.log
    echo "error 404: id=$id" 
endif
end
rm -f ${TMPFILE}

exit 0





rm -f t1.xml
rrdtool dump ~maison/rrd/temperature.rrd > t1.xml

if { test ! -s "t1.xml" } then
    echo "can't dump rrd-database"
    exit 0
endif

#make a copy
cp t1.xml t.xml


foreach id (${SENSID})
if { test -s "${id}.log" } then
	echo "update $id"
	./rrd_replace t1.xml t2.xml ${id}.log
	mv t2.xml t1.xml
endif
end

rm -f ~maison/rrd/temperature.rrd.new
#cp -p ~maison/rrd/temperature.rrd ~maison/rrd/temperature.rrd.org
rrdtool restore t1.xml ~maison/rrd/temperature.rrd.new
if { test -s ~maison/rrd/temperature.rrd.new } then
    mv ~maison/rrd/temperature.rrd.new ~maison/rrd/temperature.rrd
    chown maison ~maison/rrd/temperature.rrd
else
    echo "Error replace rrd-file"
endif

#echo "rrdtool restore t1.xml ~maison/rrd/temperature.rrd.new"
#echo "mv ~maison/rrd/temperature.rrd.new ~maison/rrd/temperature.rrd"

su - maison -c "~maison/init.d/maison start"

